assets =
{
	Asset("ANIM", "anim/pig_torch.zip"),
	Asset("SOUND", "sound/common.fsb"),
}

local prefabs = 
{
	"pigtorch_flame",
	"pigtorch_fuel",
	"spider",
	"spider_warrior",
}


local ATTACKER = {"spider", "frog", "icehound","leif","frog","rook","spider","spider","spider","spider","spider","spider"}
local ATTACKERS = {"spider_warrior", "merm", "firehound","knight","rook_nightmare","leif","spider","spider","spider","spider"}
local ATTACKERC = {6, 7, 4,2,8,4,4,4,4,4,4,4,4,4,4,4,4,4}
local ATTACKERSC = {1, 4, 4,6,7,7}
local ITEMS = {"axe", "spear", "cutstone","wall_wood_item","rope","wall_wood_item","wall_wood_item","meat","meat","meat","meat","meat","meat","meat"}
local ITEMSC = {2, 2, 10, 28,7,12,12,12,4,4,4,4,4,4,4,4,4,4,4}

local function MobAttacker(posu,mob,count)
	local i = 0
    repeat

    local attackers = SpawnPrefab(mob)
	local spawner = FindEntity(posu, 45, function(guy) return (guy:HasTag("def2spawner"))end)
	local pt2 = spawner:GetPosition()
	local rdmposx2 = math.random(-0.5, 0.5)
    attackers.Transform:SetPosition(pt2.x+rdmposx2, pt2.y, pt2.z+rdmposx2) 
    i = i + 1


    until i > count
end
local function ItemGive(posu,item,count)
	local i = 0
    repeat

    local attackers = SpawnPrefab(item)
	local pt2 = posu:GetPosition()
	local rdmposx2 = math.random(-0.1, 0.1)
    attackers.Transform:SetPosition(pt2.x+rdmposx2, pt2.y, pt2.z+rdmposx2) 
    i = i + 1


    until i > count
end




local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst:Remove()
end

local function onhit(inst,worker)
	if inst.components.spawner.child and inst.components.spawner.child.components.combat then
	    inst.components.spawner.child.components.combat:SuggestTarget(worker)
	end
	inst.AnimState:PlayAnimation("hit")
	inst.AnimState:PushAnimation("idle")
end

local function onextinguish(inst)
    if inst.components.fueled then
        inst.components.fueled:InitializeFuelLevel(0)
    end
end



local function updatedamage(inst)
    local player1 = GetPlayer()
    local dist = inst:GetDistanceSqToInst(player1)
    if dist > 450 then
	inst.components.health:SetVal(0)
	return
	end






if inst.components.health.currenthealth == 300 then
	inst.components.health:SetVal(1)
end
    if GetClock():IsDay() then
	inst.components.health:DoDelta(1)
	end
  	local pt = inst:GetPosition()
	
		local dayz_s = inst.components.health.currenthealth
print(dayz_s)

	if dayz_s > 7 then
  	local pt = inst:GetPosition()
		local attackers = SpawnPrefab("adventure_portal")
	attackers.Transform:SetPosition(pt.x+0.1, pt.y, pt.z-0.1) 

	inst.components.health:DoDelta(-151)
	
	end
	if 1==1 then
	local spawner = SpawnPrefab("deftorch2")
    spawner.Transform:SetPosition(pt.x+16, pt.y, pt.z+16) 
    spawner:AddTag("def2spawner")
	local spawner = SpawnPrefab("deftorch2")
    spawner.Transform:SetPosition(pt.x-16, pt.y, pt.z+16) 
    spawner:AddTag("def2spawner")
	local spawner = SpawnPrefab("deftorch2")
    spawner.Transform:SetPosition(pt.x-16, pt.y, pt.z-16) 
    spawner:AddTag("def2spawner")
	local spawner = SpawnPrefab("deftorch2")
    spawner.Transform:SetPosition(pt.x+16, pt.y, pt.z-16) 
    spawner:AddTag("def2spawner")
	end
print(inst.components.health.currenthealth)
	
	---ATTACKERS
	
	local mob = ATTACKER[dayz_s]
	local count = ATTACKERC[dayz_s]
	if count == nil then
	count = 3
	end
	if GetClock():IsDay() then
	count = count*2
	elseif GetClock():IsDusk() then
	count = count*1
	else
	count = count*0.75
	end
	 
	MobAttacker(inst,mob,count)
	
	local mob = ATTACKERS[dayz_s]
	local count = ATTACKERSC[dayz_s]
	if GetClock():IsDay() then
	count = count*2
	elseif GetClock():IsDusk() then
	count = count*1
	else
	count = count*0.75
	end
	MobAttacker(inst,mob,count)
	
	
	if GetClock():IsDay() then
	local mob = ITEMS[dayz_s]
	local count = ITEMSC[dayz_s]

	ItemGive(inst,mob,count)
	end
	
	local i = 0
	if GetClock():IsDay() then
	repeat

    local attackers = SpawnPrefab("log")
	local pt2 = inst:GetPosition()
	attackers.Transform:SetPosition(pt2.x+0.5, pt2.y, pt2.z) 
    local attackers = SpawnPrefab("goldnugget")
	attackers.Transform:SetPosition(pt2.x+0.5, pt2.y, pt2.z) 
    local attackers = SpawnPrefab("flint")
	attackers.Transform:SetPosition(pt2.x+0.5, pt2.y, pt2.z) 
	
    local attackers = SpawnPrefab("berries")
	attackers.Transform:SetPosition(pt2.x+0.5, pt2.y, pt2.z) 
	
	local attackers = SpawnPrefab("healingsalve")
	attackers.Transform:SetPosition(pt2.x+0.5, pt2.y, pt2.z) 
	local attackers = SpawnPrefab("healingsalve")
	attackers.Transform:SetPosition(pt2.x+0.5, pt2.y, pt2.z) 
	
	
	local attackers = SpawnPrefab("rope")
	attackers.Transform:SetPosition(pt2.x+0.5, pt2.y, pt2.z) 

    i = i + 0.8
		
    until i > inst.components.health.currenthealth
    end
end






local function fn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()

	MakeObstaclePhysics(inst, 0.33)

	inst:AddComponent("inspectable")
    inst:AddTag("deftorch")


	inst:AddComponent("burnable")
	inst.components.burnable:AddBurnFX("pigtorch_flame", Vector3(-5, 40, 0), "fire_marker")
    inst:ListenForEvent("onextinguish", onextinguish) --in case of creepy hands

    inst:AddComponent("fueled")
    inst.components.fueled.accepting = true
    inst.components.fueled.maxfuel = TUNING.PIGTORCH_FUEL_MAX
    inst.components.fueled:SetSections(4)
    inst.components.fueled.fueltype = "PIGTORCH"    
    inst.components.fueled:SetUpdateFn( function()
        if GetSeasonManager():IsRaining() then
            inst.components.fueled.rate = 0
        else
            inst.components.fueled.rate = 0
        end
        
        if inst.components.burnable and inst.components.fueled then
            inst.components.burnable:SetFXLevel(inst.components.fueled:GetCurrentSection(), inst.components.fueled:GetSectionPercent())
        end
    end)
    inst.components.fueled:SetSectionCallback( function(section)
        if section == 0 then
            inst.components.burnable:Extinguish()
        else
            if not inst.components.burnable:IsBurning() then
                inst.components.burnable:Ignite()
            end
            
            inst.components.burnable:SetFXLevel(section, inst.components.fueled:GetSectionPercent())
        end
    end)
    inst.components.fueled:InitializeFuelLevel(TUNING.PIGTORCH_FUEL_MAX)

	anim:SetBank("pigtorch")
	anim:SetBuild("pig_torch")
	anim:PlayAnimation("idle", true)


	inst:AddTag("structure")
	inst:AddComponent("lootdropper")
	inst.components.lootdropper:SetLoot({"log", "log", "log", "poop"})



	inst:ListenForEvent( "dusktime", function() updatedamage(inst) end , GetWorld())
    inst:ListenForEvent( "daytime", function() updatedamage(inst) end , GetWorld())
    inst:ListenForEvent( "nighttime", function() updatedamage(inst) end , GetWorld())
	
	inst:AddComponent("health")
    inst.components.health:SetMaxHealth(300)
	inst.components.health:SetVal(1)

	inst:AddComponent( "spawner" )
    inst.components.spawner:Configure( "spider", TUNING.TOTAL_DAY_TIME*0.1)
    inst.components.spawner:SetOnlySpawnOffscreen(false)
	--MakeSnowCovered(inst, .01)
	return inst
end

local function pigtorch_fuel()
	local inst = CreateEntity()
	inst.entity:AddTransform()
    inst:AddComponent("fuel")
    inst.components.fuel.fuelvalue = TUNING.PIGTORCH_FUEL_MAX
    inst.components.fuel.fueltype = "PIGTORCH"
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem:SetOnDroppedFn(function() inst:Remove() end )
	return inst
end

return Prefab("forest/objects/deftorch", fn, assets, prefabs),
       Prefab("forest/object/pigtorch_fuel", pigtorch_fuel) 
